/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class LeverAP
extends AP6
implements MouseListener,
MouseMotionListener {
    final int mx = 270;
    final int my = 80;
    final int n = 11;
    final int dx = 20;
    final int dy = 6;
    static final String[][] text = new String[][]{{"de", "Hebelgesetz", "Linksdrehendes Drehmoment:", "Rechtsdrehendes Drehmoment:", "M", "\u00b7", ""}, {"en", "Lever Principle", "Left side torque:", "Right side torque:", "M", "x", "T. Mzoughi 1998"}};
    private int[] gaps = new int[]{10};
    final int width = 540;
    final int height = 400;
    FontMetrics fmH;
    CanvasAP cv;
    Color bgCanvas;
    Color colorLeft;
    Color colorRight;
    Color colorLever1;
    Color colorLever2;
    Color colorLever3;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    double cos;
    double sin;
    int[] left;
    int[] right;
    double[] holesX;
    double[] holesY;
    int leftTorque;
    int rightTorque;
    int mouseX;
    int mouseY;
    int pos;
    double[] leverX;
    double[] leverY;
    double[][] fieldsX;
    double[][] fieldsY;
    boolean drag;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(540, 400);
    }

    @Override
    protected void initAttributes() {
        this.holesX = new double[21];
        this.holesY = new double[21];
        this.left = new int[11];
        this.right = new int[11];
        this.leverX = new double[4];
        this.leverY = new double[4];
        this.fieldsX = new double[11][4];
        this.fieldsY = new double[11][4];
        for (int i = 0; i < 11; ++i) {
            this.right[i] = 0;
            this.left[i] = 0;
        }
        this.left[3] = 4;
        this.right[6] = 2;
        this.rightTorque = 0;
        this.leftTorque = 0;
        this.drag = false;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.colorLeft = this.getColor(Color.red, "colorLeft");
        this.colorRight = this.getColor(Color.blue, "colorRight");
        this.colorLever1 = this.getColor(Color.green, "colorLever1");
        this.colorLever2 = this.getColor(Color.orange, "colorLever2");
        this.colorLever3 = this.getColor(Color.lightGray, "colorLever3");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.coauthor = this.getText(t[6], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 540, 400);
        this.add(this.cv);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    protected void initPanel() {
    }

    @Override
    public void run() {
    }

    double rotX(double x, double y) {
        return 270.0 + this.cos * x - this.sin * y;
    }

    double rotY(double x, double y) {
        return 80.0 - this.sin * x - this.cos * y;
    }

    void setPoint(double[] px, double[] py, int i, double x, double y) {
        px[i] = this.rotX(x, y);
        py[i] = this.rotY(x, y);
    }

    void setLever() {
        int i;
        this.setPoint(this.leverX, this.leverY, 0, -220.0, -6.0);
        this.setPoint(this.leverX, this.leverY, 1, 220.0, -6.0);
        this.setPoint(this.leverX, this.leverY, 2, 220.0, 6.0);
        this.setPoint(this.leverX, this.leverY, 3, -220.0, 6.0);
        for (i = 0; i < 11; ++i) {
            int left = (-10 + 2 * i) * 20;
            int right = left + 20;
            this.setPoint(this.fieldsX[i], this.fieldsY[i], 0, left, -6.0);
            this.setPoint(this.fieldsX[i], this.fieldsY[i], 1, right, -6.0);
            this.setPoint(this.fieldsX[i], this.fieldsY[i], 2, right, 6.0);
            this.setPoint(this.fieldsX[i], this.fieldsY[i], 3, left, 6.0);
        }
        for (i = 0; i < 21; ++i) {
            double h = (i + 1 - 11) * 20;
            this.holesX[i] = this.rotX(h, 0.0);
            this.holesY[i] = this.rotY(h, 0.0);
        }
    }

    int number() {
        int result = -1;
        for (int i = 0; i < 21; ++i) {
            if (i == 10) continue;
            double dx = (double)this.mouseX - this.holesX[i];
            double dy = (double)this.mouseY - this.holesY[i];
            int j = 0;
            if (i < 10) {
                j = this.left[10 - i];
            }
            if (i > 10) {
                j = this.right[i + 1 - 11];
            }
            if (!(dx >= -5.0) || !(dx <= 5.0) || !(dy >= -5.0) || !(dy <= (double)(j * 10 + 5))) continue;
            result = i;
            break;
        }
        return result;
    }

    void calculation(Graphics g, int nr) {
        int pos = 20;
        if (nr < 0 || nr > 1) {
            return;
        }
        g.setColor(nr == 0 ? this.colorLeft : this.colorRight);
        String s = nr == 0 ? this.text01 : this.text02;
        g.drawString(s, pos, 260 + nr * 70);
        g.drawString(this.text03, pos, 280 + nr * 70);
        g.drawString("" + (nr + 1), pos += this.fmH.stringWidth(this.text03), 286 + nr * 70);
        pos += this.fmH.stringWidth("2 ");
        String s1 = "= ";
        boolean first = true;
        for (int i = nr; i < 11 + nr - 1; ++i) {
            int k;
            int j;
            if (nr == 0) {
                j = 10 - i;
                k = this.left[j];
            } else {
                j = i;
                k = this.right[j];
            }
            if (k <= 0) continue;
            if (first) {
                first = false;
            } else {
                s1 = s1 + " + ";
            }
            s1 = s1 + this.toString(k, 1) + " " + this.newton + " " + this.text04 + " ";
            s1 = s1 + this.toString((double)j / 10.0, 2) + " " + this.meter + " ";
        }
        s1 = s1 + " =";
        double torque = (double)(nr == 0 ? this.leftTorque : this.rightTorque) / 10.0;
        String s2 = "= " + this.toString(torque, 1) + " " + this.newton + this.meter;
        if (s1.length() <= 85 && !first) {
            g.drawString(s1, pos, 280 + nr * 70);
            g.drawString(s2, pos, 300 + nr * 70);
        } else {
            g.drawString(s2, pos, 280 + nr * 70);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int i;
        if (!this.correct) {
            return;
        }
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.pos = this.number();
        if (this.pos >= 0 && this.pos < 10 && this.left[i = 10 - this.pos] > 0) {
            int n = i;
            this.left[n] = this.left[n] - 1;
        }
        if (this.pos > 10 && this.pos <= 20 && this.right[i = this.pos + 1 - 11] > 0) {
            int n = i;
            this.right[n] = this.right[n] - 1;
        }
        this.drag = true;
        this.cv.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int i;
        if (!this.correct) {
            return;
        }
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.pos = this.number();
        if (this.pos >= 0 && this.pos < 10 && this.left[i = 10 - this.pos] < 10) {
            int n = i;
            this.left[n] = this.left[n] + 1;
        }
        if (this.pos > 10 && this.pos <= 20 && this.right[i = this.pos + 1 - 11] < 10) {
            int n = i;
            this.right[n] = this.right[n] + 1;
        }
        this.drag = false;
        this.cv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.correct) {
            return;
        }
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.cv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, LeverAP.this.bgCanvas);
            LeverAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void fields(Graphics2D g) {
            LeverAP.this.setLever();
            CanvasAP.polygon(g, LeverAP.this.leverX, LeverAP.this.leverY, LeverAP.this.colorLever1, true);
            for (int i = 0; i < 11; ++i) {
                CanvasAP.polygon(g, LeverAP.this.fieldsX[i], LeverAP.this.fieldsY[i], LeverAP.this.colorLever2, true);
            }
        }

        void masses(Graphics2D g, double px, double py, int number) {
            Color c = g.getColor();
            if (number == 0) {
                return;
            }
            g.setColor(Color.black);
            CanvasAP.line(g, px, py, px, py + 5.0);
            for (int i = 0; i < number; ++i) {
                double yy = py + (double)(i * 10) + 5.0;
                g.setColor(Color.black);
                CanvasAP.line(g, px, yy, px, yy + 5.0);
                CanvasAP.rectangle(g, px - 4.0, yy + 5.0, 8.0, 5.0, c, true);
                g.setColor(c);
            }
        }

        void lever(Graphics2D g) {
            int i;
            CanvasAP.rectangle(g, 265.0, 60.0, 10.0, 140.0, LeverAP.this.colorLever3, true);
            CanvasAP.line(g, 120.0, 200.0, 420.0, 200.0);
            LeverAP.this.rightTorque = 0;
            LeverAP.this.leftTorque = 0;
            for (i = 1; i < 11; ++i) {
                LeverAP.this.leftTorque += i * LeverAP.this.left[i];
            }
            for (i = 1; i < 11; ++i) {
                LeverAP.this.rightTorque += i * LeverAP.this.right[i];
            }
            if (LeverAP.this.leftTorque > LeverAP.this.rightTorque) {
                LeverAP.this.cos = 0.96;
                LeverAP.this.sin = 0.28;
            } else if (LeverAP.this.leftTorque == LeverAP.this.rightTorque) {
                LeverAP.this.cos = 1.0;
                LeverAP.this.sin = 0.0;
            } else {
                LeverAP.this.cos = 0.96;
                LeverAP.this.sin = -0.28;
            }
            this.fields(g);
            g.setColor(LeverAP.this.colorLeft);
            for (i = 1; i < 11; ++i) {
                this.masses(g, LeverAP.this.holesX[10 - i], LeverAP.this.holesY[10 - i], LeverAP.this.left[i]);
            }
            g.setColor(LeverAP.this.colorRight);
            for (i = 1; i < 11; ++i) {
                this.masses(g, LeverAP.this.holesX[10 + i], LeverAP.this.holesY[10 + i], LeverAP.this.right[i]);
            }
            CanvasAP.circle(g, 270.0, 80.0, 2.5, Color.black, true);
            for (i = 0; i < 21; ++i) {
                CanvasAP.circle(g, LeverAP.this.holesX[i], LeverAP.this.holesY[i], 1.5, Color.black, true);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            this.lever(g2);
            CanvasAP.setAntiAliasing(g2, false);
            LeverAP.this.calculation(g, 0);
            LeverAP.this.calculation(g, 1);
            g.setColor(Color.black);
            String a = LeverAP.this.copyright(1997);
            if (!LeverAP.this.coauthor.equals("")) {
                a = a + ",  " + LeverAP.this.coauthor;
            }
            this.alignText(g2, a, this.fH, 2, 500, 380);
            if (LeverAP.this.drag) {
                this.masses(g2, LeverAP.this.mouseX, LeverAP.this.mouseY, 1);
            }
        }
    }
}

